﻿# Run the PowerShell Script in Administrator Mode
if (!([Security.Principal.WindowsPrincipal][Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)) {
    Start-Process PowerShell -Verb RunAs "-NoProfile -ExecutionPolicy Bypass -Command `"cd '$pwd'; & '$PSCommandPath';`"";
    exit;
}

$mutexName = "Global\UnzipWebServicesContentTowwwrootFolder"

# Attempt to create and acquire the mutex
$createdNew = $false
$mutex = New-Object System.Threading.Mutex($true, $mutexName, [ref]$createdNew)

if (-not $createdNew) {
   Write-Host "Another instance of the script is already running. Exiting..."
   exit
}


$wwwroot_folder = "C:\inetpub\wwwroot"
try {
    $wwwroot_folder = (Get-ItemProperty -Path Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\InetStp -Name "PathWWWRoot").PathWWWRoot
}
catch {
    $wwwroot_folder = "C:\inetpub\wwwroot"
}
$inetpub_folder = Split-Path -parent $wwwroot_folder

try {
    # Stop existing Motorola_Solutions_BFM_SQL-win.exe process in Task Manager
    $SQL_Node_Service = Get-Process Motorola_Solutions_BFM_SQL-win -ErrorAction SilentlyContinue
    if ($SQL_Node_Service) {
        # try gracefully first
        $SQL_Node_Service.CloseMainWindow()
        # kill after five seconds
        Sleep 5
        if (!$SQL_Node_Service.HasExited) {
            $SQL_Node_Service | Stop-Process -Force
        }
    }
    Remove-Variable SQL_Node_Service
}
catch {
    # echo "Error: $_"
    Start-Sleep -Seconds 3
}

try {
    # Stop existing Motorola_Solutions_BFM_WEB-win.exe process in Task Manager
    $WEB_Node_Service = Get-Process Motorola_Solutions_BFM_WEB-win -ErrorAction SilentlyContinue
    if ($WEB_Node_Service) {
        # try gracefully first
        $WEB_Node_Service.CloseMainWindow()
        # kill after five seconds
        Sleep 5
        if (!$WEB_Node_Service.HasExited) {
            $WEB_Node_Service | Stop-Process -Force
        }
    }
    Remove-Variable WEB_Node_Service
}
catch {
    # echo "Error: $_"
    Start-Sleep -Seconds 3
}

try {
    if (Test-Path -Path $wwwroot_folder) {
        # Delete all files and folders in C:\inetpub\wwwroot folder and delete the folder itself
        Remove-Item -path $wwwroot_folder -recurse
    }
    else {
        if (!(Test-Path -Path $inetpub_folder)) {
            mkdir $inetpub_folder
        }
    }
    # Create the folder C:\inetpub\wwwroot back
    mkdir $wwwroot_folder
}
catch {
    # echo "Error: $_"
    Start-Sleep -Seconds 3
}

$Virtual_Disk_For_SQL_Installer_Substituted = $false

try {
    # Initialize the path for virtual disk
    $Virtual_Disk_Path = ""
    # Initialize the output from substitution of virtual disk
    $SubstVirtualDiskOutput = ""
    
    # Loop from Z to A, ASCII decimal of Z is 90 while the ASCII decimal of A is 65
    for ($ASCII_Decimal = 90; $ASCII_Decimal -ge 65; $ASCII_Decimal--)
    {
        # Reset SubstVirtualDiskOutput variable to empty string on each iteration
        $SubstVirtualDiskOutput = ""
        # Assign alphabet (Z to A) and colon as value of Virtual_Disk_Path variable
        $Virtual_Disk_Path = [char]($ASCII_Decimal) + ":"
        # Subtitute a virtual disk with the PowerShell script folder which is in the IMPRES Battery Fleet Management folder
        $SubstVirtualDiskOutput = Subst $Virtual_Disk_Path $PSScriptRoot
        
        # If the virtual disk has been substituted previously, the output is "Drive already SUBSTed"
        # If the value of Virtual_Disk_Path variable is invalid, the output is "Invalid parameter - $Virtual_Disk_Path"
        # If the virtual disk is substituted successfully, the output is nullified
        if ($SubstVirtualDiskOutput -eq $null){
            $Virtual_Disk_For_SQL_Installer_Substituted = $true
            break
        }
    }
    
    if ( $Virtual_Disk_For_SQL_Installer_Substituted ) {
        # AngularWebApp_NodeEXE.zip is in the PowerShell script folder and the virtual disk is associated to the PowerShell script folder
        $wwwroot_Zipped_Folder_Path = $Virtual_Disk_Path + "\AngularWebApp_NodeEXE.zip"
        # Using ExtractToDirectory from System.IO.Compression.ZipFile
        # If the target folder doesn't exist, ExtractToDirectory will create it.
        # Existing files will not be overwritten and instead trigger an IOException.
        # This method requires at least .NET Framework 4.5, available for Windows Vista and newer.
        Add-Type -AssemblyName System.IO.Compression.FileSystem
        function Unzip
        {
            param([string]$zipfile, [string]$outpath)

            [System.IO.Compression.ZipFile]::ExtractToDirectory($zipfile, $outpath)
        }
        # Unzip AngularWebApp_NodeEXE.zip located on the virtual disk to C:\inetpub\wwwroot
        Unzip $wwwroot_Zipped_Folder_Path "C:\inetpub\wwwroot"
		
		
		# Move node_services and bfm_server_config.json to BFM pc app path
		$target_folder = "C:\Program Files (x86)\Motorola\IMPRES Fleet Management"

		# Stop the web service if it's running to ensure node services can be moved/deleted
		try {
			$webService = Get-Service -Name "Motorola IMPRES Fleet Management Web Application Service" -ErrorAction SilentlyContinue
			if ($webService -and $webService.Status -eq "Running") {
				Stop-Service -Name "Motorola IMPRES Fleet Management Web Application Service" -Force
				Start-Sleep -Seconds 3
			}
		} catch {
			Write-Host "Could not stop web service: $_"
			Start-Sleep -Seconds 3
		}
		
		# Ensure the target directory exists
		if (-not (Test-Path -Path $target_folder)) {
		   New-Item -ItemType Directory -Path $target_folder
		}

		# Define the folders whose contents need to be moved
		$folders_to_move_contents = @("bfm_config_files", "node_services")

		foreach ($folder in $folders_to_move_contents) {
		   $sourcePath = Join-Path -Path $wwwroot_folder -ChildPath $folder
		   $destinationPath = Join-Path -Path $target_folder -ChildPath $folder
		   
		   # Ensure the destination folder exists
		   if (-not (Test-Path -Path $destinationPath)) {
			   New-Item -ItemType Directory -Path $destinationPath
		   }
		   
		   # Check if the source folder exists
		   if (Test-Path -Path $sourcePath) {
			   # Move each item in the folder individually
			   Get-ChildItem -Path $sourcePath | ForEach-Object {
				   $itemDestinationPath = Join-Path -Path $destinationPath -ChildPath $_.Name
				   # Check if the destination already has an item with the same name
				   if (Test-Path -Path $itemDestinationPath) {
					   # Remove the existing item
					   Remove-Item -Path $itemDestinationPath -Recurse -Force
				   }
				   # Move the item to the destination directory
				   Move-Item -Path $_.FullName -Destination $itemDestinationPath
			   }
				# After moving all items, delete the source folder
				Remove-Item -Path $sourcePath -Recurse -Force
		   } else {
			   Write-Host "Folder `'$folder`' not found in `'$wwwroot_folder`'."
		   }
		}
    }
}
catch {
    # echo "Error: $_"
    Start-Sleep -Seconds 15
}

try {
    if ( $Virtual_Disk_For_SQL_Installer_Substituted ) {
        # Delete virtual disk
	    Subst $Virtual_Disk_Path /d
    }
}
catch {
    # echo "Error: $_"
    Start-Sleep -Seconds 30
}

# Restart the Motorola IMPRES Fleet Management Web Application Service
try {
    $webService = Get-Service -Name "Motorola IMPRES Fleet Management Web Application Service" -ErrorAction SilentlyContinue
    if ($webService) {
        Start-Service -Name "Motorola IMPRES Fleet Management Web Application Service"
        Write-Host "Web service started successfully."
    }
} catch {
    Write-Host "Could not start web service: $_"
    Start-Sleep -Seconds 3
}

# Release the mutex to allow other instances to run
$mutex.ReleaseMutex()
$mutex.Dispose()


